/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.crafting.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class RecipeUtil {
    private static final Method KEY_FROM_JSON = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192408_a", (Class[])new Class[]{JsonObject.class});
    private static final Method SHRINK = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_194134_a", (Class[])new Class[]{String[].class});
    private static final Method PATTERN_FROM_JSON = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192407_a", (Class[])new Class[]{JsonArray.class});
    private static final Method DISSOLVE_PATTERN = ObfuscationReflectionHelper.findMethod(ShapedRecipe.class, (String)"func_192402_a", (Class[])new Class[]{String[].class, Map.class, Integer.TYPE, Integer.TYPE});

    public static ShapedPrimer parseShaped(JsonObject json) {
        try {
            Map key = (Map)KEY_FROM_JSON.invoke(null, json.getAsJsonObject("key"));
            String[] pattern = (String[])SHRINK.invoke(null, PATTERN_FROM_JSON.invoke(null, json.getAsJsonObject("pattern")));
            int recipeWidth = pattern[0].length();
            int recipeHeight = pattern.length;
            NonNullList ingredients = (NonNullList)DISSOLVE_PATTERN.invoke(null, pattern, key, recipeWidth, recipeHeight);
            return new ShapedPrimer((NonNullList<Ingredient>)ingredients, recipeWidth, recipeHeight);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Failed to parse shaped recipe", e);
        }
    }

    public static NonNullList<Ingredient> parseShapeless(JsonObject json) {
        NonNullList ingredients = NonNullList.m_122779_();
        for (JsonElement element : json.getAsJsonArray("ingredients")) {
            ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element));
        }
        if (ingredients.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return ingredients;
    }

    public static class ShapedPrimer {
        private final NonNullList<Ingredient> ingredients;
        private final int recipeWidth;
        private final int recipeHeight;

        public ShapedPrimer(NonNullList<Ingredient> ingredients, int recipeWidth, int recipeHeight) {
            this.ingredients = ingredients;
            this.recipeWidth = recipeWidth;
            this.recipeHeight = recipeHeight;
        }

        public NonNullList<Ingredient> getIngredients() {
            return this.ingredients;
        }

        public int getRecipeWidth() {
            return this.recipeWidth;
        }

        public int getRecipeHeight() {
            return this.recipeHeight;
        }
    }
}

